import * as React from "react";

import { Button, ButtonType, Tooltip } from "twitch-core-ui";

export type Props = {
  tooltip: string;
  disabled?: boolean;
  onClick: () => void;
};

export const VodPopoutButtonComponent = (props: Props) => {
  const buttonClass = "fa-film";

  return (
    <Tooltip label={props.tooltip}>
      <Button
        data-track-click="vod-popout-button-click"
        type={ButtonType.Hollow}
        onClick={props.onClick}
        disabled={props.disabled}
        targetBlank
      >
        <i className={`fa ${buttonClass}`} />
      </Button>
    </Tooltip>
  );
};
