import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { MockedProvider } from "react-apollo/test-utils";
import { Router } from "react-router";

import { createHistory } from "aegis/functionality/utils/contrib/twilight/history";
import { MockVod } from "aegis/models/mocks";
import { waitSomeMs } from "aegis/tests/utils/wait-some-ms";
import { DisplayOption, TestSelectors, VodVideoEmbed } from "./component";

import "aegis/functionality/date-extensions";

Enzyme.configure({ adapter: new Adapter() });

function setupMount() {
  return Enzyme.mount(
    <Router history={createHistory()}>
      <MockedProvider>
        <VodVideoEmbed vod={MockVod()} />
      </MockedProvider>
    </Router>
  );
}

describe("Vod Video Embed", () => {
  it("renders and changing embed works", async () => {
    const wrapper = setupMount();

    expect(wrapper.find({ "data-test-selector": TestSelectors.ClipsOverviewURL }).hostNodes()).toHaveLength(1);

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.TwitchEmbedButton })
        .hostNodes()
        .children()
        .first()
        .prop("checked")
    ).toEqual(true);

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.UnmutedEmbedButton })
        .hostNodes()
        .children()
        .first()
        .prop("checked")
    ).toEqual(false);

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.TwitchEmbedIFrame })
        .hostNodes()
        .prop("className")
    ).toEqual("tw-block");

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.UnmutedEmbedIFrame })
        .hostNodes()
        .prop("className")
    ).toEqual("tw-hide");

    wrapper
      .find({ "data-test-selector": TestSelectors.UnmutedEmbedButton })
      .hostNodes()
      .children()
      .first()
      .simulate("change", {
        value: DisplayOption.Unmuted
      });
    await waitSomeMs();

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.TwitchEmbedButton })
        .hostNodes()
        .children()
        .first()
        .prop("checked")
    ).toEqual(false);

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.UnmutedEmbedButton })
        .hostNodes()
        .children()
        .first()
        .prop("checked")
    ).toEqual(true);

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.TwitchEmbedIFrame })
        .hostNodes()
        .prop("className")
    ).toEqual("tw-hide");

    expect(
      wrapper
        .find({ "data-test-selector": TestSelectors.UnmutedEmbedIFrame })
        .hostNodes()
        .prop("className")
    ).toEqual("tw-block");
  });
});
