import * as React from "react";

import { Button, ButtonType, Tooltip, TooltipDirection } from "twitch-core-ui";

export interface Props {
  error?: Error;
  deleted: boolean;
  loading: boolean;
  forceDisabledReason?: string;
  onClick: () => void;
}

export enum TestSelectors {
  Button = "delete-vod-and-clips-button--button"
}

export const DeleteVodAndClipsButtonComponent: React.SFC<Props> = ({
  error,
  deleted,
  forceDisabledReason,
  loading,
  onClick
}) => {
  let tooltip: string;

  if (error) {
    console.error("An error occurred deleting clips and vod", error.message);
    tooltip = "An error occurred deleting clips and vod";
  } else if (forceDisabledReason) {
    tooltip = forceDisabledReason;
  } else if (deleted) {
    tooltip = "It is already deleted";
  } else {
    tooltip = "Any associated clips will also be deleted";
  }

  return (
    <Tooltip label={tooltip} direction={TooltipDirection.Left}>
      <Button
        data-track-click="vod-delete-vod-and-clips"
        onClick={onClick}
        disabled={loading || deleted || !!forceDisabledReason}
        type={error ? ButtonType.Alert : ButtonType.Hollow}
        data-test-selector={TestSelectors.Button}
      >
        <i className="fa fa-trash" />
      </Button>
    </Tooltip>
  );
};
