import gql from "graphql-tag";

export const PanelFields = gql`
  fragment PanelFields on Panel {
    id
    description
    title
    imageURL
    linkTo
  }
`;

export const UserEmoticonFields = gql`
  fragment UserEmoticonFields on UserEmoticon {
    id
    code
  }
`;

export const UserBadgesFields = gql`
  fragment UserBadgesFields on Badge {
    id
    title
    imageURL
    largeImageURL
  }
`;

export const MessageFields = gql`
  fragment MessageFields on Message {
    id
    sentTimestamp
    type
    from {
      ...UserFields
    }
    target {
      ...UserFields
    }
    emotes {
      emote {
        id
      }
      start
      end
    }
    badges {
      id
      title
      imageURL
    }
    body
    isDeleted
    systemMessage
  }
`;

export const AdminFields = gql`
  fragment AdminFields on Admin {
    __typename
    id
    ldap
    avatarURL
    email
  }
`;

export const SuspensionFields = gql`
  fragment SuspensionFields on Suspension {
    __typename
    id
    reason
    duration
    createdAt
    permanent
  }
`;

export const DetailedSuspensionFields = gql`
  fragment DetailedSuspensionFields on Suspension {
    __typename
    id
    fromUserID
    fromUserType
    targetUserUsername
    targetUserID
    targetUserType
    targetUserPartner
    targetUserDisplayName
    content
    reason
    detailedReason
    description
    duration
    ipBan
    clearedChannelImages
    targetUserGame
    currentLiveVod
    createdAt
    updatedAt
    permanent
  }
`;

export const WarningFields = gql`
  fragment WarningFields on Warning {
    id
    clearedChannelImages
    content
    createdAt
    description
    detailedReason
    fromUserID
    reason
    targetUserID
    targetUserUsername
    updatedAt
  }
`;

export const EnforcementFields = gql`
  fragment EnforcementFields on Enforcement {
    id
    reason
    detailedReason
    fromUserID
    targetUserID
    content
    description
    enforcementType
    enforcementID
    createdAt
    updatedAt
    suspension {
      ...DetailedSuspensionFields
    }
    warning {
      ...WarningFields
    }
  }
  ${DetailedSuspensionFields}
  ${WarningFields}
`;

export const BanExceptionFields = gql`
  fragment BanExceptionFields on BanException {
    __typename
    id
    reason
    createdAt
    createdBy {
      ...AdminFields
    }
  }
  ${AdminFields}
`;

export const UserFields = gql`
  fragment UserFields on User {
    __typename
    createdAt
    displayName
    id
    isBanned
    isDMCABanned
    isDeleted
    language
    login
    profileImage
    roles
    streamEmbedURL
  }
`;

export const DetailedUserFields = gql`
  fragment DetailedUserFields on User {
    __typename
    acceptableNameConfidence
    bannedUntil
    channel {
      game
      language
      profileBannerImage
      title
      mature
    }
    dmcaViolationCount
    isLiveStreaming
    isEscalatePartner
    stream {
      title
      duration
      viewCount
    }
    suspension {
      ...SuspensionFields
    }
    banException {
      ...BanExceptionFields
    }
    reportedCount(pastSeconds: 86400) # 24 hr
    warnedCount(pastSeconds: 86400) # 24 hr
    reportSentCount(pastSeconds: 86400) # 24 hr
    tosViolationCount
    isEscalatePartner
  }
  ${SuspensionFields}
  ${BanExceptionFields}
`;

export const ShiftFields = gql`
  fragment ShiftFields on Shift {
    id
    admin {
      ...AdminFields
    }
    type
    weight
  }
  ${AdminFields}
`;

export const SimpleMessageFields = gql`
  fragment SimpleMessageFields on Message {
    id
    from {
      ...UserFields
    }
    target {
      ...UserFields
    }
    body
    sentTimestamp
  }
`;

export const ChatroomFields = gql`
  fragment ChatroomFields on Chatroom {
    __typename
    id
    ownerType
    ownerID
    name
    topic
    minimumAllowedRole
    modes
  }
`;

export const ReportHoldFields = gql`
  fragment ReportHoldFields on ReportHold {
    __typename
    id
    createdBy {
      ...AdminFields
    }
    until
    createdAt
    updatedAt
  }
  ${AdminFields}
`;

export const ReportAuditFields = gql`
  fragment ReportAuditFields on ReportAudit {
    __typename
    id
    action
    actionBy {
      ...AdminFields
    }
    hold {
      ...ReportHoldFields
    }
    diff
    createdAt
    autoResolveID
  }
  ${AdminFields}
  ${ReportHoldFields}
`;

export const SquadFields = gql`
  fragment SquadFields on Squad {
    id
    owner {
      ...UserFields
    }
    members {
      ...UserFields
    }
    createdAt
  }

  ${UserFields}
`;

export const VodFields = gql`
  fragment VodFields on Vod {
    __typename
    id
    clipsOverviewURL
    collection
    createdAt
    isDeleted
    deletedAt
    description
    offset
    title
    url
    unmutedURL
  }
`;

// Fields for subtype of report
export const ReportSubtypeFields = gql`
  fragment ReportSubtypeFields on Report {
    __typename
    id
    ... on ChatReport {
      channelID
      messageID
      entries: messages {
        edges {
          node {
            ...MessageFields
          }
          cursor
        }
      }
    }
    ... on ClipReport {
      clipURL
      clipOverviewURL
      curator {
        ...UserFields
      }
      vodURL
      slug
    }
    ... on CursePrivateGroupReport {
      messages {
        ...SimpleMessageFields
      }
    }
    ... on CursePublicGroupReport {
      messages {
        ...SimpleMessageFields
      }
    }
    ... on CurseWhisperReport {
      messages {
        ...SimpleMessageFields
      }
      rawText
    }
    ... on EmoteReport {
      emote {
        id
        code
      }
    }
    ... on ExtensionReport {
      extensionID
      extensionURL
    }
    ... on LegacyReport {
      contentID
      extra
      details
    }
    ... on LiveUpNotificationReport {
      message
    }
    ... on RoomReport {
      messages {
        ...MessageFields
      }
      room {
        ...ChatroomFields
      }
    }
    ... on UserReport {
      similarClipsURL
      chatPopupURL
      vod {
        ...VodFields
      }
      squad {
        ...SquadFields
      }
    }
    ... on VodCommentReport {
      vodComment {
        ...MessageFields
      }
      vodURL
    }
    ... on VodReport {
      vod {
        ...VodFields
      }
    }
    ... on WhisperReport {
      messages {
        ...SimpleMessageFields
      }
      rawText
    }
  }
  ${ChatroomFields}
  ${MessageFields}
  ${SimpleMessageFields}
  ${SquadFields}
  ${UserFields}
  ${VodFields}
`;

export const ReportContentFields = gql`
  fragment ReportContentFields on ReportContent {
    code
    displayName
  }
`;

export const ReportReasonFields = gql`
  fragment ReportReasonFields on ReportReason {
    code
    displayName
  }
`;

export const ReportFields = gql`
  fragment ReportFields on Report {
    __typename
    id
    status
    content {
      ...ReportContentFields
    }
    audits {
      ...ReportAuditFields
    }
    assignedto {
      ...AdminFields
    }
    assignedToQueue
    reason {
      ...ReportReasonFields
    }
    createdAt
    updatedAt
    description
    language
    origin
    rawContext
    fromUser {
      ...UserFields
    }
    targetUser {
      ...UserFields
    }
  }
  ${AdminFields}
  ${ReportAuditFields}
  ${ReportContentFields}
  ${ReportReasonFields}
  ${UserFields}
`;

export const CommentFields = gql`
  fragment CommentFields on ReportComment {
    __typename
    id
    reportID
    message
    createdAt
    createdBy {
      ...AdminFields
    }
  }
  ${AdminFields}
`;

export const AutoResolveFields = gql`
  fragment AutoResolveFields on AutoResolve {
    __typename
    id
    count
    createdAt
    content {
      ...ReportContentFields
    }
    reason {
      ...ReportReasonFields
    }
    resolveUtil
    createdBy {
      ...AdminFields
    }
    fromUser {
      type
      user {
        ...UserFields
      }
    }
    targetUser {
      type
      user {
        ...UserFields
      }
    }
  }
  ${AdminFields}
  ${ReportContentFields}
  ${ReportReasonFields}
  ${UserFields}
`;

export const PageInfoFields = gql`
  fragment PageInfoFields on PageInfo {
    __typename
    startCursor
    hasPreviousPage
    hasNextPage
    endCursor
  }
`;

export const OffsetPageInfoFields = gql`
  fragment OffsetPageInfoFields on OffsetPageInfo {
    __typename
    offset
    total
  }
`;
