import * as React from "react";

import { inject } from "mobx-react";

import { AutoCompleteInput, Suggestion, SuggestionDisplay } from "aegis/functionality/components/auto-suggest-input";
import { Admin } from "aegis/models";
import { ReportStoreProps } from "aegis/stores";

import { AlignItems, CoreImage, Display, Layout } from "twitch-core-ui";

import "./styles.scss";

export interface PublicProps {
  onSelect: (admin?: Admin) => void;
  floatSuggestions?: boolean;
  defaultValue?: string;
}

export interface DataProps {
  admins: Admin[];
}

type Props = PublicProps & ReportStoreProps & DataProps;

interface State {
  selectedAdmin?: Admin;
}

@inject("reportStore")
export class AdminSelectComponent extends React.Component<Props, State> {
  public render() {
    const suggestions: Suggestion[] = this.props.admins.map(a => ({
      value: a.ldap,
      display: (
        <Layout key={a.ldap} padding={{ left: 0.5 }} display={Display.InlineFlex} alignItems={AlignItems.Center}>
          <CoreImage key={a.ldap + "-img"} alt={a.ldap} src={a.avatarURL} className={"reassign-dropdown__avatar"} />
          <Layout key={a.ldap + "-display"} display={Display.Inline} padding={{ left: 0.5 }}>
            {a.ldap} ({a.email})
          </Layout>
        </Layout>
      )
    }));

    return (
      <AutoCompleteInput
        display={this.props.floatSuggestions ? SuggestionDisplay.ON_FOCUS : SuggestionDisplay.ALWAYS}
        onSelect={this.selectAdminByLDAP}
        suggestions={suggestions}
        suggestionCardClassName="admin-auto-complete-suggestions"
        floatSuggestions={this.props.floatSuggestions}
        defaultValue={this.props.defaultValue}
      />
    );
  }

  private selectAdminByLDAP = (ldap: string) => {
    const selected = this.props.admins.find(a => a.ldap === ldap);
    this.props.onSelect(selected);
    this.setState({ selectedAdmin: selected });
  };
}
