import * as React from "react";

import gql from "graphql-tag";

import * as Fragments from "aegis/fragments";
import { Query } from "aegis/functionality/apollo-wrapper";
import { Admin } from "aegis/models";
import { LoadingSpinner } from "twitch-core-ui";
import { AdminSelectComponent, PublicProps } from "./component";

export const FETCH_REPORT_ADMINS = gql`
  query reportAdmins {
    reportAdmins {
      ...AdminFields
    }
  }

  ${Fragments.AdminFields}
`;

export type ReportAdminsResponse = {
  reportAdmins: Admin[];
};

export class ReportAdminsQuery extends Query<ReportAdminsResponse> {}

export const AdminSelect: React.SFC<PublicProps> = props => {
  return (
    <ReportAdminsQuery displayName="AdminSelect" query={FETCH_REPORT_ADMINS} fetchPolicy="cache-first">
      {({ loading, error, data }) => {
        if (loading) {
          return <LoadingSpinner />;
        }
        if (error) {
          console.error("Error occurred fetching report admins", error);
        }

        let admins: Admin[] = [];
        if (data) {
          admins = data.reportAdmins;
        } else {
          console.error("Invalid data returned. Report admins not found");
        }

        // Show the list of admins in alphebatical order of their ldap
        admins.sort((a, b) => {
          return a.ldap.localeCompare(b.ldap);
        });

        return <AdminSelectComponent admins={admins} {...props} />;
      }}
    </ReportAdminsQuery>
  );
};
