import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { AutoCompleteInput, SuggestionDisplay, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });
describe("Auto suggest input", () => {
  it("renders", () => {
    const wrapper = Enzyme.shallow(<AutoCompleteInput suggestions={[]} onSelect={jest.fn()} />);

    expect(wrapper).toBeTruthy();
  });

  describe("with ALWAYS display", () => {
    const fn = jest.fn();
    const input = "input";
    const wrapper = Enzyme.mount(
      <AutoCompleteInput
        display={SuggestionDisplay.ALWAYS}
        suggestions={[{ value: input, display: <div>something else</div> }, { value: "value2" }]}
        onSelect={fn}
      />
    );

    it("renders suggestions by default", () => {
      expect(wrapper).toBeTruthy();
      expect(wrapper.find({ "data-test-selector": TestSelectors.SUGGESTIONS }).hostNodes().length).toBe(1);
    });

    it("clicking suggestion triggers onSelect", () => {
      wrapper
        .find({ "data-test-selector": TestSelectors.SUGGESTION_ITEM })
        .first()
        .simulate("mouseDown");

      expect(fn.mock.calls.length).toBe(1);
      expect(fn.mock.calls[0].pop()).toBe(input);
    });
  });

  describe("with ON_INPUT display", () => {
    const fn = jest.fn();
    const input = "input";
    const wrapper = Enzyme.mount(
      <AutoCompleteInput
        display={SuggestionDisplay.ON_INPUT}
        suggestions={[{ value: input, display: <div>something else</div> }, { value: "value2" }]}
        onSelect={fn}
      />
    );

    it("renders no suggestions by default", () => {
      expect(wrapper).toBeTruthy();
      expect(wrapper.find({ "data-test-selector": TestSelectors.SUGGESTIONS }).length).toBe(0);
    });
  });

  describe("with ON_FOCUS display", () => {
    const fn = jest.fn();
    const input = "input";
    const wrapper = Enzyme.mount(
      <AutoCompleteInput
        display={SuggestionDisplay.ON_FOCUS}
        suggestions={[{ value: input, display: <div>something else</div> }, { value: "value2" }]}
        onSelect={fn}
      />
    );

    it("renders no suggestions by default", () => {
      expect(wrapper).toBeTruthy();
      expect(wrapper.find({ "data-test-selector": TestSelectors.SUGGESTIONS }).length).toBe(0);
    });
  });
});
