import * as React from "react";

import { inject, observer } from "mobx-react";

import { ModalProps } from "aegis/stores";
import { AlignContent, AlignItems, Background, CoreText, StyledLayout, TextType } from "twitch-core-ui";

import "./styles.scss";

export interface BlockingModalProps {
  title: string;
  body: JSX.Element;
}

type Props = BlockingModalProps & ModalProps;

@inject("modal")
@observer
export class BlockingModalComponent extends React.Component<Props, {}> {
  render() {
    const { title, body } = this.props;
    return (
      <StyledLayout
        className="blocking-modal"
        background={Background.Accent}
        padding={{ top: 2, left: 2, bottom: 2, right: 2 }}
        alignContent={AlignContent.Center}
        alignItems={AlignItems.Center}
      >
        <StyledLayout
          background={Background.Base}
          fullHeight={true}
          alignContent={AlignContent.Center}
          padding={{ top: 5 }}
        >
          <CoreText type={TextType.H5}>{title}</CoreText>
          <StyledLayout borderTop borderBottom padding={{ y: 1 }} margin={{ y: 1 }}>
            {body}
          </StyledLayout>
        </StyledLayout>
      </StyledLayout>
    );
  }
}

// BlockingModal is a modal that takes over the entire screen and does not have a close button
export const BlockingModal = BlockingModalComponent as React.ComponentClass<BlockingModalProps>;
