import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { CollapsibleCard, TestSelector } from "./card";

Enzyme.configure({ adapter: new Adapter() });

const title = <div>title</div>;
const children = <div>children</div>;

describe("Collapsible Card", () => {
  it("renders children by default", () => {
    const wrapper = Enzyme.mount(<CollapsibleCard title={title}>{children}</CollapsibleCard>);

    expect(wrapper).toBeTruthy();
    expect(wrapper.containsMatchingElement(title)).toBeTruthy();
    expect(wrapper.containsMatchingElement(children)).toBeTruthy();
  });

  it("renders children default closed", () => {
    const wrapper = Enzyme.mount(
      <CollapsibleCard title={title} defaultClosed>
        {children}
      </CollapsibleCard>
    );

    expect(wrapper).toBeTruthy();
    expect(wrapper.containsMatchingElement(title)).toBeTruthy();
    expect(wrapper.containsMatchingElement(children)).toBeFalsy();
  });

  it("renders children with options", () => {
    const wrapper = Enzyme.mount(
      <CollapsibleCard title={title} roundedCorner>
        {children}
      </CollapsibleCard>
    );

    expect(wrapper).toBeTruthy();
    expect(wrapper.containsMatchingElement(title)).toBeTruthy();
    expect(wrapper.containsMatchingElement(children)).toBeTruthy();
  });

  it("opens and closes on click", () => {
    const wrapper = Enzyme.mount(<CollapsibleCard title={title}>{children}</CollapsibleCard>);

    expect(wrapper).toBeTruthy();
    expect(wrapper.containsMatchingElement(title)).toBeTruthy();
    expect(wrapper.containsMatchingElement(children)).toBeTruthy();

    // Click closes the card
    wrapper.find({ "data-test-selector": TestSelector.Header }).simulate("click");
    expect(wrapper.containsMatchingElement(children)).toBeFalsy();

    // Click again reopens the card
    wrapper.find({ "data-test-selector": TestSelector.Header }).simulate("click");
    expect(wrapper.containsMatchingElement(children)).toBeTruthy();

    // One more time to make sure card is closed
    wrapper.find({ "data-test-selector": TestSelector.Header }).simulate("click");
    expect(wrapper.containsMatchingElement(children)).toBeFalsy();
  });
});
