import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { CollapsibleComponent } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const title = <div>title</div>;
const children = <div>children</div>;

describe("Collapsible Component", () => {
  it("does not render children if not open", () => {
    const wrapper = Enzyme.mount(<CollapsibleComponent title={title}>{children}</CollapsibleComponent>);

    expect(wrapper).toBeTruthy();
    expect(wrapper.containsMatchingElement(title)).toBeTruthy();
    expect(wrapper.containsMatchingElement(children)).toBeFalsy();
  });

  it("does renders children if open", () => {
    const wrapper = Enzyme.mount(
      <CollapsibleComponent title={title} open>
        {children}
      </CollapsibleComponent>
    );

    expect(wrapper).toBeTruthy();
    expect(wrapper.containsMatchingElement(title)).toBeTruthy();
    expect(wrapper.containsMatchingElement(children)).toBeTruthy();
  });
});
