import * as React from "react";

import { StyledLayout } from "twitch-core-ui";

export interface Props {
  title: JSX.Element;
  open?: boolean;
}

// Barebone component for handling collapsible component
export const CollapsibleComponent: React.SFC<Props> = ({ title, open, children }) => {
  return (
    <StyledLayout fullWidth fullHeight>
      {title}
      {open && children}
    </StyledLayout>
  );
};
