import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { Modal } from "aegis/stores";
import {
  ConfirmationModalCancelSelector,
  ConfirmationModalComponent,
  ConfirmationModalConfirmSelector
} from "./component";

Enzyme.configure({ adapter: new Adapter() });

it("renders without crashing", () => {
  const testModal: Modal = new Modal();
  testModal.closeModal = jest.fn(() => {
    return;
  });
  const wrapper = Enzyme.mount(
    <ConfirmationModalComponent title="title" body="body" modal={testModal} onConfirm={testModal.closeModal} />
  );
  expect(wrapper).toMatchSnapshot();
});

it("closes modal when confirm button is clicked", () => {
  const testModal: Modal = new Modal();
  const confirmFunc = jest.fn(() => {
    return;
  });
  const cancelFunc = jest.fn(() => {
    return;
  });

  const wrapper = Enzyme.mount(
    <ConfirmationModalComponent
      title="title"
      body="body"
      modal={testModal}
      onConfirm={confirmFunc}
      onCancel={cancelFunc}
    />
  );

  wrapper
    .find({ "data-test-selector": ConfirmationModalConfirmSelector })
    .hostNodes()
    .simulate("click");
  expect(wrapper).toMatchSnapshot();
  expect(confirmFunc).toHaveBeenCalledTimes(1);
  expect(cancelFunc).toHaveBeenCalledTimes(0);
});

it("calls closes modal by default when cancel button is clicked", () => {
  const testModal: Modal = new Modal();
  testModal.closeModal = jest.fn(() => {
    return;
  });
  const confirmFunc = jest.fn(() => {
    return;
  });
  const wrapper = Enzyme.mount(
    <ConfirmationModalComponent title="title" body="body" modal={testModal} onConfirm={confirmFunc} />
  );

  wrapper
    .find({ "data-test-selector": ConfirmationModalCancelSelector })
    .hostNodes()
    .simulate("click");
  expect(wrapper).toMatchSnapshot();
  expect(testModal.closeModal).toHaveBeenCalledTimes(1);
  expect(confirmFunc).toHaveBeenCalledTimes(0);
});

it("calls canel when cancel button is clicked", () => {
  const testModal: Modal = new Modal();
  testModal.closeModal = jest.fn(() => {
    return;
  });
  const confirmFunc = jest.fn(() => {
    return;
  });
  const cancelFunc = jest.fn(() => {
    return;
  });
  const wrapper = Enzyme.mount(
    <ConfirmationModalComponent
      title="title"
      body="body"
      modal={testModal}
      onConfirm={confirmFunc}
      onCancel={cancelFunc}
    />
  );

  wrapper
    .find({ "data-test-selector": ConfirmationModalCancelSelector })
    .hostNodes()
    .simulate("click");
  expect(wrapper).toMatchSnapshot();
  expect(testModal.closeModal).toHaveBeenCalledTimes(0);
  expect(confirmFunc).toHaveBeenCalledTimes(0);
  expect(cancelFunc).toHaveBeenCalledTimes(1);
});
