import * as React from "react";

import { PortalModal } from "aegis/functionality/components/portal-modal";
import { action, observable } from "mobx";
import { observer } from "mobx-react";
import { isFunction } from "util";
import { ConfirmationModal, ConfirmationModalProps } from "./component";

export interface ChildProps {
  children: (onClickFn: () => void) => React.ReactNode;
}

@observer
export class WithConfirmationModal extends React.Component<ConfirmationModalProps & ChildProps> {
  @observable private confirmVisible: boolean = false;

  private get confirmModal(): React.ReactNode {
    return (
      <PortalModal onClose={this.hideConfirmModal} overrideWidth={true}>
        <ConfirmationModal
          {...{
            ...this.props,
            onCancel: () => {
              this.hideConfirmModal();
              if (isFunction(this.props.onCancel)) {
                this.props.onCancel!();
              }
            },
            onConfirm: () => {
              this.hideConfirmModal();
              this.props.onConfirm();
            }
          }}
        />
      </PortalModal>
    );
  }

  public render() {
    return (
      <span>
        {this.confirmVisible && this.confirmModal}
        {this.props.children(this.showConfirmModal)}
      </span>
    );
  }

  @action
  private hideConfirmModal = () => {
    this.confirmVisible = false;
  };

  @action
  private showConfirmModal = () => {
    this.confirmVisible = true;
  };
}
