import * as React from "react";

import { copyTextToClipboard } from "aegis/functionality/utils/contrib/twilight/copy-text-to-clipboard";

import "./styles.scss";

export const CopyLinkButton: React.StatelessComponent<{ children?: React.ReactNode; link: string }> = ({
  children,
  link
}) => {
  const onClick = (event: React.MouseEvent) => {
    event.stopPropagation();
    if (event.metaKey || event.altKey || event.ctrlKey) {
      window.open(link);
    } else {
      copyTextToClipboard(link);
    }
  };

  return (
    <div onClick={onClick} className="copy-link-button">
      {children}
    </div>
  );
};
