import * as classNames from "classnames";
import * as React from "react";
import { Layout, Position, ZIndex } from "twitch-core-ui";

import "./styles.scss";

interface Props {
  show?: boolean;
}

export const DropdownMenu: React.SFC<Props> = ({ children, show }) => {
  const dropdownClassname = classNames("menu-dropdown", { "menu-dropdown--toggled": show });

  const dropdown = (
    <Layout position={Position.Absolute} className={dropdownClassname} zIndex={ZIndex.Above}>
      {children}
    </Layout>
  );
  return dropdown;
};
