import * as React from "react";
import { AlignItems, CoreText, Display, Layout, StyledLayout, TextType } from "twitch-core-ui";

export interface PublicProps {
  title: string;
}

export class HeaderTitle extends React.PureComponent<PublicProps> {
  public render() {
    return (
      <Layout display={Display.Flex} alignItems={AlignItems.Center}>
        {this.props.children}
        <Layout flexGrow={1}>
          <CoreText type={TextType.Span} lines={1}>
            {this.props.title}
          </CoreText>
        </Layout>
        <StyledLayout borderBottom fullWidth margin={{ left: 1 }} />
      </Layout>
    );
  }
}
