import * as React from "react";

import * as classnames from "classnames";
import { AlignItems, Button, ButtonProps, Display, Layout, Padding, SVG, SVGAsset } from "twitch-core-ui";

import "./style.scss";

export type Props = {
  indicatorIcon: SVGAsset;
  padding?: Padding;
  leftAlignText?: boolean;
} & ButtonProps;

// IndicatorButton is a regular core ui button (supports all the core ui button props) with an indicator icon on the right of button text
export class IndicatorButton extends React.Component<Props> {
  render() {
    const { leftAlignText, children, indicatorIcon, padding } = this.props;

    const classNames = classnames("indicator-button", {
      "indicator-button__left-align-text": leftAlignText
    });

    return (
      <Layout fullWidth className={classNames}>
        <Button {...this.props}>
          <Layout fullWidth display={Display.Flex} padding={padding}>
            {children}
            <Layout padding={{ left: 0.5 }} display={Display.Flex} alignItems={AlignItems.Center}>
              <SVG width={12} height={12} asset={indicatorIcon} />
            </Layout>
          </Layout>
        </Button>
      </Layout>
    );
  }
}
