import * as React from "react";

interface Props {
  closeModal: () => void;
}

export class ModalCloserComponent extends React.PureComponent<Props, {}> {
  public componentDidMount() {
    document.addEventListener("keydown", this.handleGlobalKeypress);
  }

  public componentWillUnmount() {
    document.removeEventListener("keydown", this.handleGlobalKeypress);
  }

  public render() {
    return <div />;
  }

  private handleGlobalKeypress = (e: KeyboardEvent) => {
    // handle ESC press
    if (e.which === 27) {
      this.props.closeModal();
    }
  };
}

export const ModalCloser = ModalCloserComponent;
