import * as React from "react";

import * as classnames from "classnames";
import { inject } from "mobx-react";
import { observer } from "mobx-react";
import * as ReactModal from "react-modal";

import { ModalProps } from "aegis/stores";
import { SettingsStoreProps } from "aegis/stores/settingsstore";

import "./styles.scss";

type Props = SettingsStoreProps & ModalProps;

@inject("modal")
@inject("settingsStore")
@observer
class ModalRootComponent extends React.Component<Props, {}> {
  render() {
    const { modal, settingsStore } = this.props;

    if (!modal) {
      return;
    }
    const overlayClass = classnames({
      modal__backdrop: true,
      "tw-theme--light": settingsStore ? settingsStore.light : true,
      "tw-theme--dark": settingsStore ? settingsStore.dark : false
    });

    return (
      <ReactModal isOpen={modal.isVisible} className="modal__content" overlayClassName={overlayClass}>
        {modal.component && <modal.component {...modal.componentProps} />}
      </ReactModal>
    );
  }
}

// ModalRoot is the anchor to display modals
export const ModalRoot = ModalRootComponent as React.ComponentClass<{}>;
