import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { Modal } from "aegis/stores";
import { NotificationModalComponent, NotificationModalConfirmSelector } from "./component";

Enzyme.configure({ adapter: new Adapter() });

it("renders without crashing", () => {
  const testModal: Modal = new Modal();
  const wrapper = Enzyme.mount(<NotificationModalComponent title="title" body="body" modal={testModal} />);
  expect(wrapper).toMatchSnapshot();
});

it("renders error without crashing", () => {
  const testModal: Modal = new Modal();
  const wrapper = Enzyme.mount(<NotificationModalComponent title="title" body="body" error={true} modal={testModal} />);
  expect(wrapper).toMatchSnapshot();
});

it("closes modal when confirm button is clicked", () => {
  const testModal: Modal = new Modal();
  testModal.closeModal = jest.fn(() => {
    return;
  });
  const wrapper = Enzyme.mount(<NotificationModalComponent title="title" body="body" error={true} modal={testModal} />);

  wrapper
    .find({ "data-test-selector": NotificationModalConfirmSelector })
    .hostNodes()
    .simulate("click");
  expect(wrapper).toMatchSnapshot();
  expect(testModal.closeModal).toHaveBeenCalledTimes(1);
});

it("calls onConfirm when confirm button is clicked", () => {
  const testModal: Modal = new Modal();
  testModal.closeModal = jest.fn(() => {
    return;
  });
  const onConfirm = jest.fn(() => {
    return;
  });

  const wrapper = Enzyme.mount(
    <NotificationModalComponent title="title" body="body" modal={testModal} onConfirm={onConfirm} />
  );

  wrapper
    .find({ "data-test-selector": NotificationModalConfirmSelector })
    .hostNodes()
    .simulate("click");
  expect(wrapper).toMatchSnapshot();
  expect(testModal.closeModal).toHaveBeenCalledTimes(0);
  expect(onConfirm).toHaveBeenCalledTimes(1);
});
