import * as React from "react";
import { AlignItems, Color, CoreText, Display, JustifyContent, Layout } from "twitch-core-ui";

export const PanelTitle: React.SFC<{ title: string; length: number }> = ({ title, length }) => {
  return (
    <Layout display={Display.Flex} justifyContent={JustifyContent.Between} alignItems={AlignItems.Center} fullWidth>
      <Layout>
        <CoreText>{title}</CoreText>
      </Layout>
      <Layout>
        <CoreText color={Color.Alt2}>{length}</CoreText>
      </Layout>
    </Layout>
  );
};
