import * as React from "react";
import * as ReactDOM from "react-dom";

/**
 * DO NOT USE OUTSIDE OF PORTAL MODAL
 *
 * Injects the <PortalModal> into the <PortalRoot> and creates a portal
 * between the two (allowing the parent of the <PortalModal> to have
 * access in the VirtualDom without rendering)
 */
export class PortalInject extends React.Component {
  // Root for the portal to mount in, created by <PortalModalRoot>
  private modalRoot = document.getElementById("portal-modal-root") as HTMLElement;
  // Injected element owned by PortalInject that a portal is created within
  private el: HTMLElement = document.createElement("div");

  public componentDidMount() {
    if (!this.modalRoot) {
      throw new Error(
        "Unable to find the root to mount this modal. Are you sure you mounted the <PortalModalRoot> in this DOM?"
      );
    }
    this.modalRoot.appendChild(this.el);
  }

  public componentWillUnmount() {
    this.modalRoot.removeChild(this.el);
  }

  public render() {
    return ReactDOM.createPortal(this.props.children, this.el);
  }
}
