import * as React from "react";

import { mount } from "enzyme";
import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";
import { Provider } from "mobx-react";

import { CLOSE_BUTTON_TEST_SELECTOR } from "aegis/functionality/components/portal-modal/component";
import { StackedModalStore } from "aegis/stores";
import { StackedModal } from "./component";
import { DemoRecursiveModal, NEW_MODAL_BUTTON_SELECTOR } from "./demo";
import { BACK_BUTTON_TEST_SELECTOR } from "./modal-header";

Enzyme.configure({ adapter: new Adapter() });

describe("Stacked Modal 1", () => {
  let stackedModalStore: StackedModalStore;

  const modalRoot = document.createElement("div");
  modalRoot.setAttribute("id", "portal-modal-root");
  const body = document.querySelector("body");
  if (body) {
    body.appendChild(modalRoot);
  }

  beforeEach(() => {
    stackedModalStore = new StackedModalStore();
  });

  it("renders StackedModal in the PortalModalRoot", () => {
    const wrapper = mount(
      <StackedModal stackedModalStore={stackedModalStore}>
        <div>"test"</div>
      </StackedModal>
    );
    expect(wrapper.hostNodes()).toMatchSnapshot();
  });

  it("populates StackedModalStore correctly when stacking modals", () => {
    const wrapper = mount(
      <StackedModal stackedModalStore={stackedModalStore}>
        <StackedModal stackedModalStore={stackedModalStore}>
          <StackedModal stackedModalStore={stackedModalStore}>
            <div>"test"</div>
          </StackedModal>
        </StackedModal>
      </StackedModal>
    );
    expect(wrapper.hostNodes()).toMatchSnapshot();
    expect(stackedModalStore.openModals).toHaveLength(3);
  });

  it("maintains the stack as modals are added and removed", () => {
    const wrapper = mount(
      <Provider stackedModalStore={stackedModalStore}>
        <DemoRecursiveModal index={0}>
          <div>"test"</div>
        </DemoRecursiveModal>
      </Provider>
    );
    expect(stackedModalStore.openModals).toHaveLength(1);

    wrapper
      .find({ "data-test-selector": NEW_MODAL_BUTTON_SELECTOR })
      .first()
      .simulate("click");
    expect(stackedModalStore.openModals).toHaveLength(2);

    wrapper
      .find({ "data-test-selector": NEW_MODAL_BUTTON_SELECTOR })
      .first()
      .simulate("click");
    expect(stackedModalStore.openModals).toHaveLength(3);

    wrapper
      .find({ "data-test-selector": CLOSE_BUTTON_TEST_SELECTOR })
      .first()
      .simulate("click");
    expect(stackedModalStore.openModals).toHaveLength(2);
  });

  it("has a working back button when 2 or modals are in the stack", () => {
    const wrapper = mount(
      <Provider stackedModalStore={stackedModalStore}>
        <DemoRecursiveModal index={0}>
          <div>"test"</div>
        </DemoRecursiveModal>
      </Provider>
    );
    expect(stackedModalStore.openModals).toHaveLength(1);

    expect(wrapper.find({ "data-test-selector": BACK_BUTTON_TEST_SELECTOR })).toHaveLength(0);

    wrapper
      .find({ "data-test-selector": NEW_MODAL_BUTTON_SELECTOR })
      .first()
      .simulate("click");
    expect(stackedModalStore.openModals).toHaveLength(2);

    expect(wrapper.find({ "data-test-selector": BACK_BUTTON_TEST_SELECTOR }).find("button")).toHaveLength(1);

    wrapper
      .find({ "data-test-selector": BACK_BUTTON_TEST_SELECTOR })
      .first()
      .simulate("click");
    expect(stackedModalStore.openModals).toHaveLength(1);
  });
});
