import * as React from "react";

import { action, observable } from "mobx";
import { observer } from "mobx-react";

import { StackedModal } from "aegis/functionality/components/stacked-modal";
import { Button, CoreText, Display, FlexDirection, JustifyContent, Layout, TextType } from "twitch-core-ui";

export const NEW_MODAL_BUTTON_SELECTOR = "demo-recursive-modal__new-modal-button";

interface Props {
  onClose?: () => void;
  index: number;
  body?: string;
  title?: string;
  hideHeader?: boolean;
}

/**
 * Used to demonstrate StackedModals that stack within a single tree, in
 * this case recursively
 */
@observer
export class DemoRecursiveModal extends React.Component<Props> {
  @observable private shouldRenderModal: boolean = false;

  public render() {
    const child = this.shouldRenderModal ? <div id="child">{this.nestedModals()}</div> : null;
    return (
      <StackedModal onClose={this.props.onClose} hideHeader={this.props.hideHeader} title={this.props.title}>
        <div style={{ backgroundColor: "white", width: "700px", height: "500px" }}>
          <Layout display={Display.Flex}>
            <Layout
              display={Display.Flex}
              flexDirection={FlexDirection.Column}
              padding={2}
              justifyContent={JustifyContent.Center}
              fullWidth
            >
              <Layout flexGrow={0} className="demo-title">
                <CoreText type={TextType.H2}>{`${this.props.body || ""} ${this.props.index}`}</CoreText>
              </Layout>
              <Layout className="demo-contents">
                {child}
                <Button onClick={this.toggleModal} key="buttonKey" data-test-selector={NEW_MODAL_BUTTON_SELECTOR}>
                  Open Another Modal
                </Button>
              </Layout>
            </Layout>
          </Layout>
        </div>
      </StackedModal>
    );
  }

  private nestedModals(): JSX.Element {
    return (
      <DemoRecursiveModal
        onClose={this.toggleModal}
        index={this.props.index + 1}
        body={this.props.body}
        title={this.props.title}
      />
    );
  }

  @action
  private toggleModal = () => {
    this.shouldRenderModal = !this.shouldRenderModal;
  };
}
