import * as React from "react";

import {
  AlignContent,
  ButtonIcon,
  ButtonIconSize,
  CoreText,
  Display,
  JustifyContent,
  Layout,
  Position,
  StyledLayout,
  SVGAsset,
  TextType
} from "twitch-core-ui";

import "./styles.scss";

export const BACK_BUTTON_TEST_SELECTOR = "stacked-modal__back-button";

interface Props {
  title?: string;
  onClose?: () => void;
}

export const ModalHeader: React.SFC<Props> = props => {
  const { title, onClose } = props;
  const backButton = onClose ? (
    <StyledLayout position={Position.Fixed} className="back-button" padding={{ x: 2 }} borderRight>
      <ButtonIcon
        data-track-click="stacked-modal-header-back"
        size={ButtonIconSize.Large}
        onClick={onClose}
        icon={SVGAsset.AngleLeft}
        data-test-selector={BACK_BUTTON_TEST_SELECTOR}
      />
    </StyledLayout>
  ) : null;

  return (
    <div className="modal-header">
      {backButton}
      <Layout
        display={Display.Flex}
        alignContent={AlignContent.Center}
        padding={{ left: 2 }}
        justifyContent={JustifyContent.Center}
        fullWidth
      >
        <CoreText type={TextType.H3}>{title}</CoreText>
      </Layout>
    </div>
  );
};
