import * as React from "react";

import anchorme from "anchorme";

// Copy-pasted since it is not exposed in anchorme
// Found at: https://github.com/alexcorvi/anchorme.js/blob/gh-pages/src/util.ts
export interface URLObj {
  reason: string;
  protocol: string;
  raw: string;
  encoded: string;
}

export interface Props {
  className?: string;
}

export const aegisUploadsRegex = /\b(?<!\/)(https?:\/\/)?(leviathan-prod\.|)s3-us-west-2\.amazonaws\.com\/(aegis-uploads|file-uploads)?[\w/\-?=%.]+/;

const shouldExclude = (urlObj: URLObj) => {
  return !aegisUploadsRegex.test(urlObj.raw);
};

/**
 * Text with links component, to be used on text bodies that may have
 * Aegis image upload links Will NOT link on urls that are on domains
 * other than amazonaws.com/aegis-uploads
 *
 * That said, please do not use this for anything other than comments
 * input by admins or staff. Do NOT use this for descriptions
 */
export class TextWithLinks extends React.Component<Props> {
  private ref = React.createRef<HTMLDivElement>();

  componentDidMount() {
    const currentText = this.ref.current!.innerHTML;
    this.ref.current!.innerHTML = anchorme(currentText, {
      exclude: shouldExclude,
      attributes: [{ name: "target", value: "blank" }]
    });
  }

  render() {
    return (
      <p className={this.props.className} ref={this.ref}>
        {this.props.children}
      </p>
    );
  }
}
