import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { SegmentedButtonOption } from "twitch-core-ui";
import { TestSelectors, UserInputComponent } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("UserInput", () => {
  it("renders without defaults and callback without crashing", () => {
    spyOn(console, "error");
    const wrapper = Enzyme.shallow(<UserInputComponent name="test" lookupByID={jest.fn()} lookupByLogin={jest.fn()} />);
    expect(wrapper.find({ "data-test-selector": TestSelectors.InputField }).length).toBe(1);
  });

  it("renders with correct selection given defaultLogin", () => {
    spyOn(console, "error");
    const wrapper = Enzyme.shallow(
      <UserInputComponent name="test" lookupByID={jest.fn()} lookupByLogin={jest.fn()} defaultLogin="default-login" />
    );

    const inputTypeWrapper = wrapper.find(SegmentedButtonOption);
    expect(inputTypeWrapper.find({ label: "Login" }).props().checked).toBe(true);
    expect(inputTypeWrapper.find({ label: "ID" }).props().checked).toBe(false);
  });

  it("renders with correct selection given defaultID", () => {
    spyOn(console, "error");
    const wrapper = Enzyme.shallow(
      <UserInputComponent name="test" lookupByID={jest.fn()} lookupByLogin={jest.fn()} defaultID="default-id" />
    );

    const inputTypeWrapper = wrapper.find(SegmentedButtonOption);
    expect(inputTypeWrapper.find({ label: "Login" }).props().checked).toBe(false);
    expect(inputTypeWrapper.find({ label: "ID" }).props().checked).toBe(true);
  });
});
