import { Base64 } from "js-base64";

export function encodeURIParams(obj: { [key: string]: string }): string {
  const p: string[] = [];
  for (const k in obj) {
    if (obj.hasOwnProperty(k) && obj[k]) {
      p.push(`${encodeURIComponent(k)}=${Base64.encodeURI(obj[k])}`);
    }
  }
  return p.join(";");
}
