import * as React from "react";

import { FallbackProps } from "react-error-boundary";

import { RollbarContext, withRollbarContext } from "./context";

export type RollbarHandlerProps = {
  componentName: string;
  context?: {};
} & FallbackProps;

// RollbarHandlerComponent should only be used to wrap errors caught by error boundary.
// Rollbar alert will be sent once when this component is rendered (should be when error occurred)
class RollbarHandlerComponent extends React.PureComponent<RollbarHandlerProps & RollbarContext> {
  componentDidMount() {
    const { componentName, rollbar, error, context, componentStack } = this.props;

    rollbar.error({
      componentName: componentName,
      error: error && {
        name: error.name,
        message: error.message,
        stack: error.stack
      }, // Passing error directly results in an empty string when rollbar receives it
      context: context,
      pathname: window.location.pathname,
      query: window.location.search,
      stackTrace: componentStack
    });
  }

  render() {
    return this.props.children;
  }
}

export const RollbarHandler = withRollbarContext<RollbarContext, RollbarHandlerProps>((c: RollbarContext) => {
  return c;
})(RollbarHandlerComponent);
