import * as Rollbar from "rollbar";
import { createContext } from "../utils/contrib/twilight/context";

export interface RollbarContext {
  rollbar: Rollbar;
}

const ROLLBAR_TOKEN = "ed5f5f35ffda41369d60cb9c67497075";
const prodHostName = "aegis.safety.internal.justin.tv";
const stagingHostName = "aegis.service.safety-staging.justin.tv";
const devEnvironment = "development";

export const { InnerProvider: RollbarProvider, withContext: withRollbarContext } = createContext<RollbarContext>(
  "RollbarContext",
  initializeRollbarContext()
);

function initializeRollbarContext(): RollbarContext {
  let environment: string = devEnvironment;

  if (window.location.hostname === prodHostName) {
    environment = "production";
  }

  if (window.location.hostname === stagingHostName) {
    environment = "staging";
  }

  return {
    rollbar: Rollbar.init({
      accessToken: ROLLBAR_TOKEN,
      enabled: process.env.NODE_ENV === "production" && environment !== devEnvironment, // Unit tests/local development shouldn't trigger rollbar alert
      payload: {
        host: window.location.hostname,
        environment: environment
      },
      itemsPerMinute: 12 // Prevent flooding rollbar when too many things go horribly wrong
    })
  };
}
