function preventInputFireEvent(run: (event: KeyboardEvent) => void) {
  return (event: KeyboardEvent) => {
    if (!(event.target instanceof HTMLInputElement || event.target instanceof HTMLTextAreaElement)) {
      event.preventDefault();
      run(event);
    }
  };
}

export function preventFireOnInput(handler: { [key: string]: (keyEvent?: KeyboardEvent) => void }) {
  const newHandler: { [key: string]: (keyEvent?: KeyboardEvent) => void } = {};
  for (const key in handler) {
    if (handler.hasOwnProperty(key)) {
      newHandler[key] = preventInputFireEvent(handler[key]);
    }
  }
  return newHandler;
}
