import { getFullLanguageFromCode } from "./language-from-language-code";

describe("language-from-language-code", () => {
  it("resolves when no short code is passed in", () => {
    expect(getFullLanguageFromCode()).toBeNull();
  });

  it("resolves known short code", () => {
    expect(getFullLanguageFromCode("en")).toBe("English");
  });

  it("resolves known short code with country", () => {
    expect(getFullLanguageFromCode("en-US")).toBe("English");
  });

  it("resolves unknown code not in list", () => {
    expect(getFullLanguageFromCode("other")).toBe("other");
  });
});
