import { languageCodes } from "./consts";

export const getFullLanguageFromCode = (languageShortCode?: string) => {
  if (languageShortCode) {
    const code = languageCodes[stripCountryCode(languageShortCode)];
    return code ? code.name : languageShortCode; // if the language is not in our list, reutrn itself instead
  }
  return null;
};

const stripCountryCode = (languageLongCode: string) => {
  return languageLongCode.split("-")[0];
};
