import * as React from "react";

import { toast } from "react-toastify";
import { InFeatureNotification, InFeatureNotificationType } from "twitch-core-ui";

export const getMemoryUsedPercentage = () => {
  if (!window.performance.memory) {
    return 0;
  }
  return window.performance.memory.usedJSHeapSize / window.performance.memory.jsHeapSizeLimit;
};

const MEMORY_WARNING_ID = "MEMORY_WARNING_ID";

export function memoryUsageWarning() {
  if (!toast.isActive(MEMORY_WARNING_ID)) {
    toast.error(
      <InFeatureNotification
        title={"Resource usage warning"}
        description={"This tab is using too much memory, please refresh the page"}
        link={{ onClick: () => location.reload(), children: "Click here to refresh now" }}
        type={InFeatureNotificationType.Error}
      />,
      {
        toastId: MEMORY_WARNING_ID,
        autoClose: false,
        className: "custom-error-notifications",
        closeButton: false,
        progressClassName: "custom-error-progress-bar"
      }
    );
  }
}
