import { History } from "history";
import * as QueryString from "query-string";

export interface PageQueryProps {
  page?: string;
}

export const AddPageToQueryString = (history: History, page: number) => {
  const queryParams = QueryString.parse(location.search) as {};
  history.push({
    pathname: history.location.pathname,
    search: QueryString.stringify({ ...queryParams, page: page })
  });
};

export const PageFromQueryProps = (queryProps: PageQueryProps) => {
  const page: number = queryProps.page ? parseInt(queryProps.page, 10) : 1;
  if (page < 1) {
    return 1;
  }
  return page;
};
