const offsetMilliseconds = () => {
  const offsetMinutes = new Date().getTimezoneOffset();
  return offsetMinutes * 60 * 1000;
};

export const removeTZOffset = (millisecondTimestamp: number): number => millisecondTimestamp - offsetMilliseconds();
export const addTZOffset = (millisecondTimestamp: number): number => millisecondTimestamp + offsetMilliseconds();

const toPaddedString = (num: number) => {
  return num < 10 ? `0${num}` : num.toString();
};

export const toDateTimeLocal = (ts: string, defaultValue: number) => {
  const tsInt = parseInt(ts, 10) || defaultValue;
  const date = new Date(addTZOffset(tsInt));
  return `${date.getFullYear()}-${toPaddedString(date.getMonth() + 1)}-${toPaddedString(
    date.getDate()
  )}T${toPaddedString(date.getHours())}:${toPaddedString(date.getMinutes())}`;
};
