import { Suspension } from "./models";
import { OffsetPageInfo } from "./offset_pageinfo";

export type Enforcement = {
  id: string;
  reason: string;
  detailedReason: string;
  fromUserID: string;
  targetUserID: string;
  content: string;
  description: string;
  enforcementType: EnforcementTypes;
  enforcementID: string;
  createdAt: string;
  updatedAt: string;
  suspension?: Suspension;
  warning?: Warning;
};

export type Warning = {
  id: string;
  clearedChannelImages: boolean;
  reason: string;
  detailedReason: string;
  fromUserID: string;
  targetUserID: string;
  targetUserUsername: string;
  content: string;
  description: string;
  enforcementType: string;
  enforcementID: string;
  createdAt: string;
  updatedAt: string;
};

export enum EnforcementTypes {
  Warning = "warning",
  Suspension = "suspension"
}

export class EnforcementConnection {
  enforcements: Enforcement[];
  pageInfo: OffsetPageInfo;
}
