// Commonly used values for polling. These are meant for guildlines not strict rules
export enum PollingInterval {
  Fast = 1000, // Operation is not expensive AND we need frequent update
  Normal = 5000, // Operation is expensive OR we need frequent update
  Slow = 10000 // We don't need frequent update but would be nice to update it once in a while
}

export enum AutoResolveUserType {
  IS = "IS",
  NOT = "NOT"
}

export enum ShiftType {
  Main = "main",
  Leader = "leader",
  Investigative = "investigative"
}

export enum AltUserType {
  Initial = "INITIAL",
  Email = "EMAIL",
  Device = "DEVICEID",
  IP = "IP"
}

export enum AdminActionType {
  Delete = "delete"
}
