import { MockAdmin, MockTime, MockUser } from ".";
import { AutoResolve, AutoResolveUser, AutoResolveUserType } from "..";
import { MockReportContent, MockReportReason } from "./report";

export const MockAutoResolve = (overrides?: Partial<AutoResolve>): AutoResolve => {
  return {
    id: "id",
    createdBy: MockAdmin(),
    count: 123,
    createdAt: MockTime(),
    targetUser: MockAutoResolveUser(),
    fromUser: MockAutoResolveUser(),
    content: MockReportContent(),
    reason: MockReportReason(),
    resolveUtil: MockTime(),
    __typename: "AutoResolve",
    ...overrides
  };
};

export const MockAutoResolveUser = (overrides?: Partial<AutoResolveUser>): AutoResolveUser => {
  return {
    type: AutoResolveUserType.IS.toString(),
    user: MockUser(),
    ...overrides
  };
};
