import { Enforcement } from "..";
import { EnforcementTypes, Warning } from "../enforcements";
import { Suspension } from "../models";
import { MockTime } from "./time";

export const MockEnforcement = (overrides?: Partial<Enforcement>): Enforcement => {
  return {
    id: "id",
    reason: "reason",
    detailedReason: "detailedReason",
    fromUserID: "fromUserID",
    targetUserID: "targetUserID",
    content: "content",
    description: `description
    this
    is
    a
    really
    long
    description
    that
    needs
    a
    show
    more
    button`,
    enforcementType: EnforcementTypes.Warning,
    enforcementID: "enforcementID",
    warning: MockWarning(),
    createdAt: MockTime(),
    updatedAt: MockTime(),
    ...overrides
  };
};

export const MockWarning = (overrides?: Partial<Warning>): Warning => {
  return {
    id: "id",
    clearedChannelImages: false,
    reason: "reason",
    detailedReason: "detailedReason",
    fromUserID: "fromUserID",
    targetUserID: "targetUserID",
    targetUserUsername: "targetUserUsername",
    content: "content",
    description: "description",
    enforcementType: "enforcementType",
    enforcementID: "enforcementID",
    createdAt: MockTime(),
    updatedAt: MockTime(),
    ...overrides
  };
};
export const MockSuspension = (overrides?: Partial<Suspension>): Suspension => {
  return {
    id: "id",
    fromUserID: "fromUserID",
    fromUserType: "fromUserType",
    targetUserUsername: "targetUserUsername",
    targetUserID: "targetUserID",
    targetUserType: "targetUserType",
    targetUserPartner: false,
    targetUserDisplayName: "targetUserDisplayName",
    content: "content",
    reason: "reason",
    detailedReason: "detailedReason",
    description: "description",
    ipBan: 1,
    clearedChannelImages: false,
    origin: "origin",
    targetUserGame: "targetUserGame",
    createdAt: MockTime(),
    updatedAt: MockTime(),
    permanent: false,
    ...overrides
  };
};
