import { Comment } from "aegis/features/reports";
import { ReportContent, ReportContentCode, ReportReason, ReportReasonCode } from "..";
import { MockAdmin } from "./admin";
import { MockTime } from "./time";

export const MockReportContent = (override?: Partial<ReportContent>): ReportContent => {
  return {
    code: ReportContentCode.User,
    displayName: "displayName",
    ...override
  };
};

export const MockReportReason = (override?: Partial<ReportReason>): ReportReason => {
  return {
    code: ReportReasonCode.Spam,
    displayName: "displayName",
    ...override
  };
};

export const MockReportComment = (override?: Partial<Comment>): Comment => {
  return {
    id: "id",
    reportID: "reportID",
    message: "message",
    createdAt: new Date(MockTime()),
    createdBy: MockAdmin(),
    ...override
  };
};
