import { MockTime } from ".";
import { User, UserRole } from "..";
import { DetailedUser } from "../user";

export const MockUser = (override?: Partial<User>): User => {
  return {
    id: "id",
    login: "login",
    isBanned: true,
    isDMCABanned: true,
    isDeleted: true,
    language: "en",
    displayName: "display",
    profileImage: "https://profileimg.png",
    roles: [UserRole.Staff],
    createdAt: MockTime(),
    streamEmbedURL: "streamEmbedURL",
    __typename: "User",
    ...override
  };
};

export const MockDetailedUser = (override?: Partial<DetailedUser>): DetailedUser => {
  return {
    ...MockUser(),
    acceptableNameConfidence: 123,
    dmcaViolationCount: 1,
    isLiveStreaming: true,
    reportedCount: 4,
    reportSentCount: 5,
    warnedCount: 7,
    tosViolationCount: 3,
    isEscalatePartner: false,
    ...override
  };
};
