import { AltUserType, ShiftType } from "./enums";
import { ReportContent, ReportReason } from "./report";
import { User } from "./user";

export type PagedResponse<T> = {
  edges: Edge<T>[];
  pageInfo: PageInfo;
};

export type Edge<T> = {
  node: T;
  cursor: string;
};

export type PageInfo = {
  startCursor: string;
  endCursor: string;
  hasNextPage: boolean;
  hasPreviousPage: boolean;
};

export type Badge = {
  title: string;
  imageURL: string;
};

export type Admin = {
  id: string;
  ldap: string;
  avatarURL: string;
  email: string;
  activeShifts: Shift[];
  __typename?: string;
};

export type BanException = {
  id: string;
  reason: string;
  createdAt: string;
  createdBy?: Admin;
};

export type Suspension = {
  id: string;
  fromUserID: string;
  fromUserType: string;
  targetUserUsername: string;
  targetUserID: string;
  targetUserType: string;
  targetUserPartner: boolean;
  targetUserDisplayName: string;
  content?: string;
  reason?: string;
  detailedReason?: string;
  description?: string;
  duration?: number;
  ipBan: number | boolean;
  clearedChannelImages: boolean;
  origin: string;
  targetUserGame: string;
  createdAt: string;
  updatedAt: string;
  permanent: boolean;
};

export type Chatroom = {
  id: string;
  ownerType: string;
  ownerID: string;
  name: string;
  topic: string;
  minimumAllowedRole: string;
  modes: string;
  __typename?: string;
};
export type AutoResolveUser = {
  type: string;
  user: User;
};

export type AutoResolve = {
  id: string;
  createdBy: Admin;
  count: number;
  createdAt: string;
  targetUser?: AutoResolveUser;
  fromUser?: AutoResolveUser;
  content?: ReportContent;
  reason?: ReportReason;
  disabledAt?: string;
  resolveUtil?: string;
  __typename?: string;
};

export type Me = {
  id: string;
  fullName: string;
  admin?: Admin;
  __typename?: string;
};

export type Vod = {
  id: string;
  clipsOverviewURL?: string;
  collection?: string;
  createdAt: string;
  deletedAt?: string;
  description?: string;
  isDeleted: boolean;
  offset?: string;
  title: string;
  unmutedURL: string;
  url: string;
};

export type Shift = {
  id: string;
  admin: Admin;
  type: ShiftType;
  weight: number;
};

export type AltUserInfo = {
  type: AltUserType[];
  user: User;
  matched: User;
};

export type Stream = {
  duration: number;
  title: string;
  viewCount: number;
  thumbnailURL: string;
  user: User;
};
