export class ReportContent {
  code: ReportContentCode;
  displayName: string;
}

export class ReportReason {
  code: ReportReasonCode;
  displayName: string;
}

export enum ReportContentCode {
  ChannelFeedComment = "channel_feed_comment_report",
  ChannelFeedPost = "channel_feed_post_report",
  Chat = "chat_report",
  Clip = "clip_report",
  Collection = "collection_report",
  Community = "community_report",
  CursePrivateGroup = "curse_private_group",
  CursePublicGroup = "curse_public_group",
  CursePublicServer = "curse_public_server",
  CurseWhisper = "curse_whisper",
  Emote = "emote_report",
  Extension = "extension_report",
  LiveUp = "live_up_report",
  Raid = "raid_report",
  Room = "room_report",
  SingsDuetSeed = "sings_duet_seed_report",
  SingsGroupBio = "sings_group_bio_report",
  SingsGroupChat = "sings_group_chat_report",
  SingsGroupName = "sings_group_name_report",
  SingsVodComment = "sings_vod_comment_report",
  User = "user_report",
  VodComment = "vod_comment_report",
  Vod = "vod_report",
  Whisper = "whisper_report"
}

export enum ReportReasonCode {
  BanEvasion = "ban_evasion",
  BitsViolation = "bits_violation",
  ChatBanEvasion = "chat_ban_evasion",
  Cheating = "cheating",
  CommunityRulesViolation = "community_rules_violation",
  CommunityTosViolation = "community_tos_violation",
  CreativeConduct = "creative_conduct",
  Ddos = "ddos",
  Gore = "gore",
  Harassment = "harassment",
  Harm = "harm",
  HatefulConduct = "hateful_conduct",
  HateSpeech = "hate_speech",
  Impersonation = "impersonation",
  Miscategorized = "miscategorized",
  MusicConduct = "music_conduct",
  Nongaming = "nongaming",
  Nudity = "nudity",
  OffensiveBadge = "offensive_badge",
  OffensiveUsername = "offensive_username",
  Other = "other",
  Porn = "porn",
  Prohibited = "prohibited",
  Selfharm = "selfharm",
  Sexual = "sexual",
  SexualContent = "sexual_content",
  SexualViolence = "sexual_violence",
  SocialEatingViolation = "social_eating_violation",
  Spam = "spam",
  StaffImpersonation = "staff_impersonation",
  Suggestive = "suggestive",
  TosBanEvasion = "tos_ban_evasion",
  Underaged = "underaged",
  Violence = "violence"
}
