import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockUser } from "./mocks";
import { channelLink, getNameAsDisplayed } from "./user";

Enzyme.configure({ adapter: new Adapter() });

describe("User model tests", () => {
  it("renders user with display name as login properly", () => {
    const user = MockUser();
    user.displayName = user.login;
    expect(getNameAsDisplayed(user)).toMatchSnapshot();
  });

  it("renders user with display name unlike login properly", () => {
    const user = MockUser();
    user.displayName = user.login + "notlikethat";
    expect(getNameAsDisplayed(user)).toMatchSnapshot();
  });

  it("renders channel link", () => {
    const user = MockUser();
    expect(channelLink(user)).toMatchSnapshot();
  });
});
