import * as React from "react";

import * as QueryString from "query-string";
import { Helmet } from "react-helmet";
import { RouteComponentProps } from "react-router";

import { AccountInfo } from "aegis/features/account-info";

export interface QueryProps {
  id?: string;
  tabID?: string;
}

export class AccountInfoPage extends React.Component<RouteComponentProps<QueryProps>> {
  render() {
    const { location } = this.props;
    let queryProps: QueryProps = {};
    if (location.search) {
      queryProps = QueryString.parse(location.search) as QueryProps;
    }
    return (
      <>
        <Helmet>
          <title>Account Overview</title>
        </Helmet>
        <AccountInfo {...queryProps} />
      </>
    );
  }
}
