import * as React from "react";

import * as QueryString from "query-string";
import { Helmet } from "react-helmet";
import { RouteComponentProps } from "react-router";

import { BanForm } from "aegis/features/banform";

export enum TestSelectors {
  BanFormPage = "ban-form-page"
}
interface QueryProps {
  query?: string;
}

class Query {
  targetUser: string;
  targetUserID: string;
  description: string;
  locationOfContent: string;
  content: string;
  reason: string;
  detailedReason: string;
  chatlog: string;
  whisper: string;
  reportID: string;
}

type Props = RouteComponentProps<QueryProps>;

export class BanFormPage extends React.Component<Props> {
  render() {
    const { search } = this.props.location;
    let q = new Query();
    if (search) {
      q = QueryString.parse(search) as Query;
    }

    return (
      <div data-test-selector={TestSelectors.BanFormPage}>
        <Helmet>
          <title>Suspension Form</title>
        </Helmet>
        <BanForm
          description={this.nonNull(q.description)}
          defaultContent={this.nonNull(q.content)}
          defaultReason={this.nonNull(q.reason)}
          defaultDetailedReason={this.nonNull(q.detailedReason)}
          locationOfContent={this.nonNull(q.locationOfContent)}
          targetUser={this.nonNull(q.targetUser)}
          targetUserID={this.nonNull(q.targetUserID)}
          placeholders={{
            chatlog: this.nonNull(q.chatlog),
            reportID: this.nonNull(q.reportID),
            whisper: this.nonNull(q.whisper)
          }}
        />
      </div>
    );
  }
  private nonNull = (s: string) => {
    return s ? s : "";
  };
}
