import * as React from "react";

import * as QueryString from "query-string";
import { Helmet } from "react-helmet";
import { RouteComponentProps } from "react-router";

import { ChatActivity } from "aegis/features/chat-activity";
import { CoreText, FontSize, Layout, StyledLayout } from "twitch-core-ui";

interface QueryProps {
  users?: string;
}

export enum TestSelectors {
  ChatActivityPage = "chat-activity__page"
}

type Props = RouteComponentProps<QueryProps>;

export class ChatActivityPage extends React.Component<Props> {
  render() {
    const { location } = this.props;
    const queryProps: QueryProps = QueryString.parse(location.search) as QueryProps;
    const users = queryProps.users ? queryProps.users.split(",") : null;

    return (
      <Layout fullWidth padding={{ x: 2 }} data-test-selector={TestSelectors.ChatActivityPage}>
        <Helmet>
          <title>{"Chat Activity"}</title>
        </Helmet>
        <Layout padding={{ y: 2 }}>
          <CoreText fontSize={FontSize.Size4}>{"Chat Activity Checker"}</CoreText>
        </Layout>
        <StyledLayout flexGrow={1} borderBottom />
        <ChatActivity users={users} />
      </Layout>
    );
  }
}
