import * as React from "react";

import { inject, observer } from "mobx-react";
import * as QueryString from "query-string";
import { Helmet } from "react-helmet";
import { RouteComponentProps } from "react-router";

import { ChatLogs } from "aegis/features/chatlogs";
import { ChatSearch, DEFAULT_SEARCH_STATE } from "aegis/features/chatsearch";
import { ChatStore, ChatStoreParams } from "aegis/stores";
import { Display, Layout } from "twitch-core-ui";

import "./style.scss";

interface StoreProps {
  chatStore?: ChatStore;
}

interface QueryProps {
  query: string;
}

export enum TestSelectors {
  ChatLogPage = "chatlog-page"
}

type Props = StoreProps & RouteComponentProps<QueryProps>;

@inject("chatStore")
@observer
export class ChatPage extends React.Component<Props> {
  render() {
    const { chatStore, location } = this.props;

    let q = DEFAULT_SEARCH_STATE;
    if (location.search && chatStore) {
      q = QueryString.parse(location.search) as ChatStoreParams;
      chatStore.update(q);
    }
    return (
      <Layout display={Display.Flex} fullWidth>
        <Helmet>
          <title>Chat Logs</title>
        </Helmet>
        <div className="chatlog-page-container" data-test-selector={TestSelectors.ChatLogPage}>
          <ChatSearch />
          <ChatLogs />
        </div>
      </Layout>
    );
  }
}
