import * as React from "react";

import { Helmet } from "react-helmet";

import { PendingEmoticons } from "aegis/features/emotes/components/pending-emoticons";

import "./styles.scss";

export enum TestSelectors {
  EmoteApprovalPage = "emote-approval-page"
}

export interface PublicProps {}

type Props = PublicProps;

export class EmoteApprovalPage extends React.Component<Props> {
  public render() {
    return (
      <div className="emote-approval" data-test-selector={TestSelectors.EmoteApprovalPage}>
        <Helmet>
          <title>Emote Approval</title>
        </Helmet>
        <PendingEmoticons />
      </div>
    );
  }
}
